//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 22: Introduction to Multicomponent Distillation.
//Example  : 22.2 Pg 741
//Title: Flash distillation of multicomponent mixtures. 
//================================================================================================

package Ex22_2
model Ex22_2_1
//The mixture from Example 22.1 is subjected to flash distillation.Example 22.1 is not done as it is a graph problem. Cp valuea and deltaH values for components are taken from literature.

 
//===================
// Parameter Section
parameter Real K1(unit="nil")=2.23            "Equilibirium ratio";
parameter Real K2(unit="nil")=1.01            "Equilibirium ratio";
parameter Real K3(unit="nil")=0.462           "Equilibirium ratio";
parameter Real f(unit="nil")=0.6              "Fraction of feed that is vapourized";
parameter Real T(unit="C")=105                "Flash temperature, which is assumed";
parameter Real Hliquid(unit="cal/mol")=0      "Enthalpy of vapour"; 

//===================
// Variable Section
Real xb(unit="nil")               "Mole fraction of component in bottom,it is a summation value";

//==================
//Equation  Section 
equation
xb=(0.33/(0.6*(K1-1)+1))+(0.37/(0.6*(K2-1)+1))+(0.3/(0.6*(K3-1)+1));
//0.33 is fraction of hexane, 0.37 is fraction of heptane,0.30 is fraction of octane in feed.

end Ex22_2_1;

model Ex22_2_2
//The mixture from Example 22.1 is subjected to flash distillation.Example 22.1 is not done as it is a graph problem. Cp valuea and deltaH values for components are taken from literature.

 
//===================
// Parameter Section
parameter Real K1(unit="nil")=2.23            "Equilibirium ratio";
parameter Real K2(unit="nil")=1.01            "Equilibirium ratio";
parameter Real K3(unit="nil")=0.462           "Equilibirium ratio";
parameter Real f(unit="nil")=0.6              "Fraction of feed that is vapourized";
parameter Real T(unit="C")=105                "Flash temperature, which is assumed";
parameter Real Hliquid(unit="cal/mol")=0      "Enthalpy of vapour"; 

//===================
// Variable Section
Real y1(unit="nil")               "MOle fraction of component ";
Real y2(unit="nil")               "MOle fraction of component ";
Real y3(unit="nil")               "MOle fraction of component ";
Real T0(unit="C")                 "Preheat temperature";
Real Cpbar(unit="cal/mol.C")      "Average specific heat";
Real Hvapour(unit="cal/mol")      "Enthalpy of vapour"; 

//==================
//Equation  Section 
equation
y1=K1*(0.33/(0.6*(K1-1)+1));
y2=K2*(0.37/(0.6*(K2-1)+1));
y3=K3*(0.30/(0.6*(K3-1)+1));
Hvapour=(0.6*((y1*6370)+(y2*7510)+(y3*8560))); //Enthalpy values are taken from literature
Cpbar=(0.33*62)+(0.37*70)+(0.30*78);  //Cp values are taken from literature
Cpbar*(T0-T)=4345;

end Ex22_2_2;

end Ex22_2;
