//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 22: Introduction to Multicomponent Distillation.
//Example  : 22.3 Pg 744
//Title: Fractionation of multicomponent mixtures. 
//================================================================================================

model Ex22_3

// A table 22.1 Pg744 is given and certain calculations are done in it.

//===================
// Parameter Section
parameter Real K1(unit="nil")=2.23          "Equilibirium ratio of hexane";
parameter Real K2(unit="nil")=1.01          "Equilibirium ratio of heptane";
parameter Real K3(unit="nil")=0.462         "Equilibirium ratio of octane";
parameter Real F(unit="mol/h")=100          "Feed rate";
parameter Real xF(unit="nil")=0.33          "Mole fraction of hexane";
parameter Real xD(unit="nil")=0.99          "Mole fraction of hexane at the top";
parameter Real xB(unit="nil")=0.01          "Mole fraction of hexane at the bottom";

//===================
// Variable Section
Real D(unit="mol/h")                "Overhead product flow rate";
Real B(unit="mol/h")                "Bottom product flow rate";
Real x(unit="mol/h")                "Variable to represent amount of hexane in overhead";
Real alphaLKHK(unit="nil")          "Relative volatility";
Real Nmin(unit="nil")               "Minimum number of plates at total reflux";
Real Nmin1(unit="nil")              "Minimum number of plates at total reflux";
Real alphabar(unit="nil")           "Relative volatility";
Real alpha1(unit="nil")             "Relative volatility for different case";
Real xD3(unit="nil")                "Mole fraction of component";

//==================
//Equation  Section 
equation
F*xF= D*xD+(100-D)*xB;
B=100-D;
x=D*xD;
alphaLKHK= K1/K2;  
Nmin= log((xD/xB)/(xB/0.544))/log(alphaLKHK)-1;
alphabar=(2.53*2.21*2.15)^(1/3);
Nmin1=log((xD/xB)/(xB/0.544))/log(alphabar)-1;
alpha1=K2/K3;
(Nmin1+1)= log((xB/0.544)/(xD3/0.446))/log(alpha1);

end Ex22_3;
