//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 23: Leaching and extraction.
//Example  : 23.2 Pg 780
//Title: Liquid Extraction.
//================================================================================================

package Ex23_2
model Ex23_2_1
//===================
// Parameter Section
parameter Real y0(unit="nil")=0         "Mass fraction of solute";
parameter Real x0(unit="nil")=100       "Mass fraction in liquid phase";
parameter Real xa(unit="nil")=100       "Mass fraction in liquid phase";
parameter Real xbstar(unit="nil")=0     "Mass fraction at equibilirium";
parameter Real xb(unit="nil")=3         "Mass fraction at entrance ";
parameter Real V(unit="nil")=6          "6 volumes of solvent";
parameter Real KD(unit="nil")=80        "Distribution coefficient";
parameter Real L(unit="nil")=100        "100 volume of aqueous phase";

//===================
// Variable Section
Real E(unit="nil")          "Extraction factor";
Real x(unit="nil")          "Recovery";
Real X(unit="nil")          "Variable to represent x1/x0";

//==================
//Equation  Section 
equation
E=(V*KD)/L;
X=(1/(1+E));
x=1-X;

end Ex23_2_1;

model Ex23_2_2
//===================
// Parameter Section
parameter Real y0(unit="nil")=0         "Mass fraction of solute";
parameter Real x0(unit="nil")=100       "Mass fraction in liquid phase";
parameter Real xa(unit="nil")=100       "Mass fraction in liquid phase";
parameter Real xbstar(unit="nil")=0     "Mass fraction at equibilirium";
parameter Real xb(unit="nil")=3         "Mass fraction at entrance ";
parameter Real V(unit="nil")=6          "6 volumes of solvent";
parameter Real KD(unit="nil")=80        "Distribution coefficient";
parameter Real L(unit="nil")=100        "100 volume of aqueous phase";
parameter Real E(unit="nil")=4.8        "Extraction factor";

//===================
// Variable Section
Real x1(unit="nil")         "Recovery";
Real X1(unit="nil")         "Variable to represent x2/x0";


//==================
//Equation  Section 
equation
X1=1/(1+E)^2;
x1=1-X1;

end Ex23_2_2;

model Ex23_2_3
//===================
// Parameter Section
parameter Real y0(unit="nil")=0         "Mass fraction of solute";
parameter Real x0(unit="nil")=100       "Mass fraction in liquid phase";
parameter Real xa(unit="nil")=100       "Mass fraction in liquid phase";
parameter Real xbstar(unit="nil")=0     "Mass fraction at equibilirium";
parameter Real xb(unit="nil")=3         "Mass fraction at entrance ";
parameter Real V(unit="nil")=6          "6 volumes of solvent";
parameter Real KD(unit="nil")=80        "Distribution coefficient";
parameter Real L(unit="nil")=100        "100 volume of aqueous phase";

//===================
// Variable Section
Real ya(unit="nil")         "Mass fraction";
Real xastar(unit="nil")     "Mass fraction at equilibirium";
Real N(unit="nil")          "Number of stages";

//==================
//Equation  Section 
equation
ya=(97*xa)/6;
xastar=ya/KD;
N=log((xa-xastar)/(xb-xbstar))/log(4.8);

end Ex23_2_3;

end Ex23_2;
