//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 24: Drying of solids
//Example  : 24.1 Pg 809
//Title:  Cross circulation Drying 
//================================================================================================

package Ex24_1
model Ex24_1_1
//===================
// Parameter Section
parameter Real mu(unit="cP")=0.0205       "Viscosity";
parameter Real Tw(unit="F")=80            "Wet bulb temperature";
parameter Real Tdb(unit="F")=160          "Dry bulb temperature";
parameter Real v(unit="ft/s")=8           "Velocity";
parameter Real Pr(unit="nil")=0.69        "Prandtl number";
parameter Real k(unit="Btu/h.ft")=0.0171  "Thermal conductivity";

//===================
// Variables Section
Real rho(unit="lb/ft^3")        "Density";
Real G(unit="lb/h.ft^2")        "Mass velocity";
Real Re(unit="nil")             "Reynolds number";
Real Nu(unit="nil")             "Nusselt number";
Real hy(unit="Btu/h.F.ft^2")    "heat transfer coefficient";
Real Rc(unit="lb/h.ft^2")       "COnstant drying rate";

//==================
//Equation  Section 
equation
rho=(29/369)*(492/620);
G=v*3600*0.0641;
Re=(0.5*G)/(2.42*mu); //Its given 1.86*10^4 in T.B. Here we get 18605.
Nu=0.037*(Re)^0.8 * (Pr)^0.33;
hy=(Nu*k)/0.5;
Rc= hy*(Tdb-Tw)/1049;

end Ex24_1_1;

model Ex24_1_2
//===================
// Parameter Section
parameter Real mu(unit="cP")=0.0205       "Viscosity";
parameter Real Tw(unit="F")=80            "Wet bulb temperature";
parameter Real Tdb(unit="F")=160          "Dry bulb temperature";
parameter Real v(unit="ft/s")=8           "Velocity";
parameter Real Pr(unit="nil")=0.69        "Prandtl number";
parameter Real k(unit="Btu/h.ft")=0.0171  "Thermal conductivity";

//===================
// Variables Section
Real mv(unit="lb/h")     "RATE of drying";

//==================
//Equation  Section 
equation
mv=0.221*8;

end Ex24_1_2;

end Ex24_1;
