//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 24: Drying of solids
//Example  : 24.2 Pg 812
//Title:  Through circulation drying
//================================================================================================

model Ex24_2
extends Modelica.Constants;

//===================
// Parameter Section
parameter Real k(unit="Btu/lb.F.h")=0.0171      "From App.12";
parameter Real Cp(unit="Btu/lb.F")=0.25         "From App.14";
parameter Real Twb(unit="F")=80                 "Wet bulb temperature";
parameter Real Tdb(unit="F")=160                "Dry bulb temperature";
parameter Real cs(unit="nil")=0.245             "COnstant. For Fig19.2";

//===================
// Variables Section
Real QT(unit="Btu")             "Qty of heat to be transferred";
Real mp(unit="lb")              "Mass";
Real Ap(unit="ft^2")            "Area of surface";
Real A(unit="ft^2")             "Total area";
Real rho(unit="lb/ft^3")        "Density";
Real Re(unit="nil")             "Reynolds number";
Real Pr(unit="nil")             "Prandtl number";
Real h(unit="Btu/h.F.ft^2")     "Heat transfer coefficient";
Real mg(unit="lb/h")            "Mass flow rate of air";
Real deltaT1(unit="F")          "temp difference";
Real deltaT2(unit="F")          "temp difference";
Real deltaTL(unit="F")          "temp difference";
Real qT(unit="Btu/h")           "Rate of heat transfer";
Real tT(unit="h")               "Drying time";

//==================
//Equation  Section 
equation
QT=0.8*1049;
mp=((pi*(1/4)^2)/(4*144))*(3/12)*120;
Ap= (3/12)*(pi*(1/4))/12;
A=(8/mp)*Ap;
rho=(29/359)*(492/620);
Re= ((1/48)*4*rho)/(0.02*6.72*10^(-4));
Pr=(Cp*0.02*2.42)/k;
h=(k*1.17*Re^0.585*Pr^0.33)/(1/48);
mg=4*3600*0.0641;
deltaT1=Tdb-Twb;
deltaT2=15.83;
deltaTL= (deltaT1-deltaT2)/log(deltaT1/deltaT2);
qT=28.4*12.9*deltaTL;
tT=QT/qT;



end Ex24_2;
