//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 24: Drying of solids
//Example  : 24.3 Pg 830
//Title:  Drying equipment
//================================================================================================

model Ex24_4
//===================
// Parameter Section
 parameter Real mu(unit="cP")=0.0205       "Viscosity";
parameter Real Tw(unit="F")=80            "Wet bulb temperature";
parameter Real Tdb(unit="F")=160          "Dry bulb temperature";
parameter Real v(unit="ft/s")=8           "Velocity";
parameter Real Pr(unit="nil")=0.69        "Prandtl number";
parameter Real k(unit="Btu/h.ft")=0.0171  "Thermal conductivity";
parameter Real HF(unit="nil")=0.005       "Humidity of feed gas,from Fig 19.2";

//===================
// Variables Section
Real mg(unit="lb/h")      "Mass flow rate of gas";
Real mvent(unit="lb/h")   "Mass flow rate of vented gas";
Real mR(unit="lb/h")      "Mass flow rate of recycled gas";
Real mv(unit="lb/h")      "Mass flow rate of gas";
Real q1(unit="Btu/h")     "Heat load";
Real Ha(unit="nil")       "Humidity of gas";
Real Hb(unit="nil")       "Humidity of  gas";
Real Ta(unit="F")         "Temperature";
Real q2(unit="Btu/h")     "Heat load";
Real x(unit="nil")        "Fraction lost";
Real Q1(unit="Btu")       "Qty of heat transferred";
Real q4(unit="Btu/h")     "Heat load";
Real eta(unit="nil")      "Efficiency";

//==================
//Equation  Section 
equation
mg=1846*0.5; //In Book its given 943. Its wrong printing mistake.
mvent=0.05*mg;
mR=0.95*mg;
q1=2.9*8*(158-100);
mv=q1/1040;
Ha-HF=0.0274;
Hb=(0.95*Ha)+(0.05*0.005);
(Tdb-Ta)= q1/(mg*0.245);
q2=mvent*(154.2-70)*0.245;
x=q1/(q1+q2);
Q1=88*0.5*(101-70);
q4=Q1/4.52;
eta= q1/(q1+q4+q2);

end Ex24_4;
