//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 25: Adsorption and fixed bed separations
//Example  : 25.1 Pg843 
//Title:  Adsorption equipment
//================================================================================================

package Ex25_1
model Ex25_1_1

//===================
// Parameter Section

parameter Real X(unit = "NA") = 0.002 "Percentage of n-hexane in the airstream";
parameter Real P_t(unit = "mm Hg") = 760 "Adsorption pressure";
parameter Real T(unit = "°C") = 20 "Bed temperature";
parameter Real M(unit = "NA") = 86.17 "Molecular weight of the hexane";
parameter Real P_star(unit = "mm Hg") = 120 "Pressure of the system at given temperature";
parameter Real rho(unit = "g/cm3") = 0.615 "Density at normal boiling point";
parameter Real v(unit = "cm3/g of carbon") = 0.31 "Volume of iquid adsorbed per 100 g of carbon";

//===================
// Variable Section

Real p(unit = "mm Hg") "Partial pressure of hexane";
Real V(unit = "cm3/g mol") "Volume occupied by hexane";
Real W(unit = "g/g of carbon") "Equilibrium capacity for the bed";
Real c1(unit = "NA") "";

//===================
// Equation Section

equation
p = X * P_t;
V = M / rho;
c1 =  ((T+273.15)/V) * log10(P_star/p) ;
W = v * rho;
end Ex25_1_1;

model Ex25_1_2

//===================
// Parameter Section

parameter Real X(unit = "NA") = 0.002 "Percentage of n-hexane in the airstream";
parameter Real P_t(unit = "mm Hg") = 760 "Adsorption pressure";
parameter Real T(unit = "°C") = 40 "Bed temperature";
parameter Real M(unit = "NA") = 86.17 "Molecular weight of the hexane";
parameter Real P_star(unit = "mm Hg") = 276 "Pressure of the system at given temperature";
parameter Real rho(unit = "g/cm3") = 0.615 "Density at normal boiling point";
parameter Real v(unit = "cm3/g of carbon") = 0.27 "Volume of iquid adsorbed per 100 g of carbon";

//===================
// Variable Section

Real p(unit = "mm Hg") "Partial pressure of hexane";
Real V(unit = "cm3/g mol") "Volume occupied by hexane";
Real W(unit = "g/g of carbon") "Equilibrium capacity for the bed";
Real c1(unit = "NA") "";

//===================
// Equation Section

equation
p = X * P_t;
V = M / rho;
c1 = ((T+273.15)/V) * log10(P_star/p) ;
W = v * rho;
end Ex25_1_2;

end Ex25_1;
