//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 25:Adsorption and Fixed bed separations 
//Example  : 25.3 Pg 856
//Title:  Adsorption equipment
//================================================================================================

package Ex25_3
model Ex25_3_1
//===================
// Parameter Section

parameter Real N_tau(unit = "NA") = -1.6 "";
parameter Real D_p(unit = "cm") = 0.37 "Diameter of the particle";
parameter Real nu(unit = "cm2/s") = 0.152 "Kinematic viscosity of the system";
parameter Real D_v(unit = "cm2/s") = 0.0861 "Diffusivity of the system";
parameter Real u_o(unit = "cm/s") = 58 "Velocity of the particle";
parameter Real E(unit = "NA") = 0.457 "";
parameter Real l(unit = "cm") = 8 "Length of the bed";
parameter Real tau(unit = "NA") = 0.495;

//===================
// Variable Section

Real N(unit = "NA") "";
Real Kc_a(unit = "s-1") "";

//===================
// Equation Section

equation

N = N_tau/(tau - 1);
Kc_a = (N * u_o)/l;

end Ex25_3_1;

model Ex25_3_2

//===================
// Parameter Section

parameter Real N_tau(unit = "NA") = -1.6 "";
parameter Real D_p(unit = "cm") = 0.37 "Diameter of the particle";
parameter Real nu(unit = "cm2/s") = 0.152 "Kinematic viscosity of the system";
parameter Real D_v(unit = "cm2/s") = 0.0861 "Diffusivity of the system";
parameter Real u_o(unit = "cm/s") = 58 "Velocity of the particle";
parameter Real E(unit = "NA") = 0.457 "";
parameter Real l(unit = "cm") = 8 "Length of the bed";
parameter Real tau(unit = "NA") = 0.495;

//===================
// Variable Section
Real a(unit = "cm-1") "";
Real Kc(unit = "cm/s") "";
Real kc_e(unit = "cm/s") "";
Real kc_i(unit = "cm/s") "";
Real Re(unit = "NA") "Reynolds number";
Real Sc(unit = "NA") "Schmidt number";
Real Sh(unit = "NA") "Sherwood number";

//===================
// Equation Section

equation

Re = D_p * u_o / nu;
Sc = nu / D_v;
Sh = 1.17 * (Re)^0.585 * (Sc)^(1/3);
kc_e = Sh * D_v / D_p;
a = 6 * (1 -E) / D_p;
Kc = 23/a;
kc_i = 1 / (1/Kc - 1/kc_e);


end Ex25_3_2;

end Ex25_3;
