//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 25: Adsorption and fixed bed separations
//Example  : 25.4 Pg 861
//Title:  Adsorption Equipment.
//================================================================================================

package Ex25_4
model Ex25_4_1

//===================
// Parameter Section

parameter Real P_t(unit = "mm Hg") = 760 "Total pressure of the system";
parameter Real X(unit = "NA") = 0.0012 "Volume percent of MEK";
parameter Real M(unit = "Na") = 72.1 "Molecular weight of MEK";
parameter Real rho(unit = "g/cm3") = 0.75 "Density of MEK at boiling point";
parameter Real T(unit = "K") = 308 "Temperature of the bed";
parameter Real P_star(unit = "mm Hg") = 151 "Pressure at the given temperature of the bed";
parameter Real a(unit = "g / g of carbon") = 0.24 "Gram adsorbed per gram of carbon";
parameter Real V(unit = "ft3/min") = 16000 "Volumetric flow rate of the gas";

//===================
// Library Section

extends Modelica.Math;
   
//===================
// Variable Section

Real v(unit = "cm3/g") "Volume of the bed";
Real p(unit = "mm Hg") "Partial pressure";
Real S(unit = "NA") "";
Real W_sat(unit = "g/g of c") "Saturation capacity of the gas";
Real W(unit = "g/g of C") "Capacity of the gas"; 

//===================
// Equation Section

equation
v = M/rho;
p = X * P_t;
S = T * log10(P_star / p) / v;
W_sat = a * rho;
W = (1/3) * W_sat;
end Ex25_4_1;

model Ex25_4_2

//===================
// Parameter Section

parameter Real u_o(unit = "ft/s") = 1 "Velocity";
parameter Real v(unit = "ft3/min") = 16000 "Volumetric flowrate of MEK";
parameter Real c1(unit = "s/min") = 60 "Conversion factor";
parameter Real D(unit = "ft") = 18.4 "Diameter of the bed";
parameter Real L(unit = "ft") = 4 "Depth of the bed";
parameter Real X(unit = "NA") = 0.0012 "Volume percent of MEK";
parameter Real M(unit = "g/gmol") = 72.1 "Molecular weight of MEK";
parameter Real rho_b(unit = "lb/ft3") = 30 "Density of "; //??????????
parameter Real t_o(unit = "°K") = 273 "Datum temperature";
parameter Real t_r(unit = "°K") = 298 "Given temperature";
parameter Real Y(unit = "") = 359 ""; //??????????
parameter Real lu_1(unit = "ft") = 2.5 "Length of the used bed for the first case";
parameter Real lu_2(unit = "ft") = 3.5 "Length of the used bed for the second case";
parameter Real mu(unit = "lb/ft.s") = 1.21 * 10^(-5) "Viscosity of MEK";
parameter Real rho_f(unit = "lb/ft3") = 0.074 "Density of MEK";
parameter Real D_p(unit = "ft") = 1.08 * 10^(-2) "Diameter of the particle";
parameter Real e(unit = "") = 0.35 ""; //???????????
parameter Real c2(unit = "") = 32.2 "";
parameter Real l_2(unit = "ft") = 0.7 "Length from the leading side";
parameter Real W_sat(unit = "g/g of c") = 0.18 "Saturation capacity of the gas";
parameter Real W(unit = "g/g of C") = 0.06"Capacity of the gas";
parameter Real c3(unit = "s/h") = 3600 "Conversion factor";

//===================
// Variable Section

Real A(unit = "Ft2") "Area of the bed";
Real c_o(unit = "lb/ft3") ""; //??????????/
Real t_star(unit = "h") "";
Real t_b1(unit = "h") "";
Real t_b2(unit = "h") "";
Real delP(unit = "lbf/ft3");

//===================
// Equation Section

equation
A = v / (u_o * c1);
c_o = (X/Y) * (t_o/t_r) * M;
t_star = (rho_b * L * (W_sat - W) ) / (u_o * c_o * c3);
t_b1 = (lu_1/L) *t_star;
t_b2 = (lu_2/L) *t_star;
delP = ( 150 * mu * u_o * (1 - e)^2 / (c2 * l_2^2 * D_p^2 * e^3) ) + ( 1.75 * u_o^2 * rho_f * (1 - e) / ( c2 * l_2 * D_p * e^3));

end Ex25_4_2;

end Ex25_4;
