//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 25: Adsorption and fixed bed separations.
//Example  : 25.7 Pg 868
//Title: Ion exchange
//================================================================================================

model Ex25_7
//===================
// Parameter Section
parameter Real d(unit="cm")=2          "Diameter";
parameter Real l(unit="cm")=30         "Length";
parameter Real d1(unit="m")=0.6        "Diameter of ion exchange";
parameter Real l1(unit="cm")=150       "Length of ion exchange";
parameter Real Y(unit="mol/L")=1.15    "Variable to represent rhob*Wsat";
parameter Real c0(unit="mol/L")=0.008  "COncentration";
parameter Real c01(unit="mol/L")=2     "COncentration";

//===================
// Variable Section
Real LUB(unit="cm")       "Length of unused bed";
Real X(unit="nil")        "Varaiable to represent tb/tstar";
Real tstar(unit="h")      "Time to staurate 1st portion of bed";
Real tstar1(unit="min")   "Time to staurate 1st portion of bed";
Real tb(unit="h")         "Time at break point";
Real t(unit="min")        "Time ";
Real u0(unit="cm/s")      "Superficical velocity";


//==================
//Equation  Section 
equation
(0.75/1.15)=(1-(LUB/l));
X=(1-(LUB/l1));
u0=(3*3785*1)/(930*60);
tstar=(Y*l1)/(u0*c0*3600);
tb=tstar*X;
tstar1= (Y*l1/(u0*c01*60));
t=2*tstar1;


end Ex25_7;
