//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 26: Membrane separation process.
//Example  : 26.3 Pg 912
//Title: Separation of liquids
//================================================================================================

package Ex26_3
model Ex26_3_1
//===================
// Parameter Section
parameter Real T(unit="C")=60           "Temperature";
parameter Real Jmix(unit="Kg/m^2.h")=0.2"Flux";
parameter Real Pav(unit="mmHg")=149     "Vapour pressure of H2O at 60C";
parameter Real Pbv(unit="mmHg")=340     "Vapour pressure of Ethanol at 60C";
parameter Real P2(unit="mmHg")=30       "Pressure";
parameter Real xA(unit="nil")=0.221     "Mole fraction";
parameter Real xB(unit="nil")=0.779     "Mole fraction";

//===================
// Variable Section
Real gammaA(unit="nil")         "Activity coefficient of A";
Real gammaB(unit="nil")         "Activity coefficient of B";
Real y(unit="nil")              "Mole fraction";
Real deltaPA(unit="mmHg")       "Pressure difference";
Real QA(unit="Kg/h.m^2.atm")    "Permeability of A";
Real deltaPB(unit="mmHg")       "Pressure difference";
Real QB(unit="Kg/h.m^2.atm")    "Permeability of B";

//==================
//Equation  Section 
equation
log(gammaA)=(0.7947+1.615*xA)*xB^2;
log(gammaB)=(1.6022-1.615*xB)*xA^2;
y=(92.9/18)/((92.9/18)+(7.1/46));
deltaPA=(gammaA*xA*Pav)-(0.971*15);
QA=0.1858/0.0679; //deltaPA is converted to atm=0.0679
deltaPB=(gammaB*xB*Pbv)-(0.029*15);
QB=0.0142/0.355;

end Ex26_3_1;

model Ex26_3_2
//===================
// Parameter Section
parameter Real T(unit="C")=60           "Temperature";
parameter Real Jmix(unit="Kg/m^2.h")=0.2"Flux";
parameter Real Pav(unit="mmHg")=149     "Vapour pressure of H2O at 60C";
parameter Real Pbv(unit="mmHg")=340     "Vapour pressure of Ethanol at 60C";
parameter Real P2(unit="mmHg")=30       "Pressure";
parameter Real xA(unit="nil")=0.221     "Mole fraction";
parameter Real xB(unit="nil")=0.779     "Mole fraction";

//===================
// Variable Section
Real RA(unit="nil")             "Constant";
Real RB(unit="nil")             "Constant";
Real alpha(unit="nil")          "Membrane selectivity for pervapouration";
Real a(unit="nil")              "Constant";
Real b(unit="nil")              "Constant";
Real c(unit="nil")              "Constant";
Real ydash(unit="nil")          "Weight fraction";

//==================
//Equation  Section 
equation
RA=P2/(2.01*Pav);
RB=P2/(1.02*Pbv);
alpha=(152*2.01*Pav)/(1.02*Pbv*0.87);
a=alpha*RA-RB;
b=RB+xA-1-alpha*(RA+xA);
c=alpha*xA;
a*(ydash)^2 -(b*ydash)+c=0;

end Ex26_3_2;

end Ex26_3;
