//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 28: Properties and handling of particulate solids.
//Example  : 28.2 Pg 986
//Title: Size Reduction. 
//================================================================================================

model Ex28_2
//===================
// Parameter Section

parameter Real m(unit="ton/h")=100   "Mass flow rate of the feed";
parameter Real Dpa(unit="mm")=50.8   "Diameter of the inlet screen";
parameter Real Dpb(unit="mm")=3.175  "Diameter of the outlet screen";
parameter Real Wi(unit="nil")=12.74  "Work index for limestone. Its taken from table 28.2 Pg 986";

//===================
// Variable Section
Real P(unit="kW")       "Power required";

//==================
//Equation  Section 
equation

P= m*0.3162*Wi*((1/sqrt(Dpb))-(1/sqrt(Dpa)));
end Ex28_2;
