//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 29: Mechanical separations.
//Example  : 29.2 Pg 1029
//Title: Cake filters.
//================================================================================================

model Ex29_2
// Values taken from Example 29.1 which is not done as it contains graph.
//===================
// Parameter Section
parameter Real t(unit="min")=5                    "Filter cycle time";
parameter Real q(unit="gal/min")=10               "Flow rate";
parameter Real rho(unit="lb/ft^3")=62.3           "Density";
parameter Real mu(unit="lb/ft.s")=6.72*10^(-4)    "Viscosity";
parameter Real f(unit="nil")=0.3                  "Friction factor";
parameter Real alpha0(unit="ft/lb")=2.9*10^10;
parameter Real CF(unit="lb/ft^3")=14.7            "SLurry concentration"; 

//===================
// Variable Section
Real deltap(unit="lb/ft^2")       "Pressure drop";
Real c(unit="nil")                "Constant"; 
Real mc(unit="lb/s")              "mass flowrate";
Real AT(unit="ft^2")              "Area";

//==================
//Equation  Section 
equation
deltap=144*20*(14.69/29.92);
c= CF/(1-(2-1)*(CF/rho));
mc=(10/60)*(1/7.48)*(1/((CF/168.8)+1))*CF;
AT=mc*((alpha0*mu)/(2*19.24*deltap^0.74*32.17*f*(1/300)))^0.5;

end Ex29_2;
