//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 4: Basic Equations of Fluid Flow 
//Example  : 4.1 Pg 73
//Title: Mass Balance in a flowing Fluid
//================================================================================================

package Ex4_1
model Ex4_1_1
//===================
// Parameter Section

parameter Real a1(unit="ft2")=0.0233   "a1 is the area for 2 inch pipe";
parameter Real a2(unit="ft2")=0.0513   "a2 is the area for 3 inch pipe";
parameter Real a3(unit="ft2")=0.01414  "a3 is the area for 1.5 inch pipe";
parameter Real sg(unit="nil")=0.887    "sg is the specific gravity of crude oil";

//===================
// Variable Section 

Real m(unit="lb/h")      "mdot is the mass flow rate";
Real q(unit="ft3/h")     "q is the total volumetric flowrate of the fluid";
Real rho(unit="lb/ft3")  "rho is the density of the fluid";

//==================
// Equation  Section 
equation
q=(30*60)/7.48;
rho=0.887*62.37;
m= (q*rho);

end Ex4_1_1;

model Ex4_1_2
//===================
// Parameter Section

parameter Real a1(unit="ft2")=0.0233   "a1 is the area for 2 inch pipe";
parameter Real a2(unit="ft2")=0.0513   "a2 is the area for 3 inch pipe";
parameter Real a3(unit="ft2")=0.01414  "a3 is the area for 1.5 inch pipe";
parameter Real sg(unit="nil")=0.887    "sg is the specific gravity of crude oil";

//===================
// Variable Section 
Real Va(unit="ft/s")     "Velocity through pipe A";
Real Vb(unit="ft/s")     "Velocity through pipe B";
Real Vc(unit="ft/s")     "Velocity through pipe C";
Real q(unit="ft3/h")     "q is the total volumetric flowrate of the fluid";

//==================
// Equation  Section 
equation
q=(30*60)/7.48;
Va = (q/(a1*3600)); //It is multiplied by 3600 because 1h=3600 sec.
Vb = (q/(a2*3600));
Vc = (q/(a3*2*3600));

end Ex4_1_2;

model Ex4_1_3

//===================
// Parameter Section

parameter Real a1(unit="ft2")=0.0233   "a1 is the area for 2 inch pipe";
parameter Real a2(unit="ft2")=0.0513   "a2 is the area for 3 inch pipe";
parameter Real a3(unit="ft2")=0.01414  "a3 is the area for 1.5 inch pipe";
parameter Real sg(unit="nil")=0.887    "sg is the specific gravity of crude oil";

//===================
// Variable Section 

Real m(unit="lb/h")      "mdot is the mass flow rate";
Real Ga(unit="lb/ft2.h") "Ga is the mass velocity through pipe A";
Real Gb(unit="lb/ft2.h") "Gb is the mass velocity through pipe B";
Real Gc(unit="lb/ft2.h") "Gc is the mass velocity through pipe C";
Real q(unit="ft3/h")     "q is the total volumetric flowrate of the fluid";
Real rho(unit="lb/ft3")  "rho is the density of the fluid";

//==================
// Equation  Section 
equation
q=(30*60)/7.48;
rho=0.887*62.37;
m= (q*rho);
Ga = (m/a1);
Gb = (m/a2);
Gc = (m/(2*a3));
 
end Ex4_1_3;

end Ex4_1;
