//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 4: Basic Equations of Fluid Flow 
//Example  : 4.2 Pg 74
//Title: Mass Balance in a flowing Fluid
//================================================================================================
model Ex4_2

//===================
// Parameter Section
parameter Real Va(unit = "m/s") = 15   "Va is the inlet velocity";
parameter Real Da(unit = "m") =0.05    "Da is the diameter of heater inlet";
parameter Real Db(unit = "m") =0.065   "Db is the diameter of heater outlet";
parameter Real pa(unit = "atm") =2     "pa is the pressure at heater inlet";
parameter Real pb(unit = "atm") =1.6   "pb is the pressure at heater outlet";
parameter Real Ta(unit = "K") =293.16  "Ta is the temperature at heater inlet";
parameter Real Tb(unit = "K") =363.16  "Tb is the temperature at heater outlet";

//===================
// Variable Section 

Real Vb(unit = "m/s") "Vb is the outlet velocity";

//==================
// Equation  Section 
 equation
 Vb = (Va*pa*Tb*Da^2)/(Db^2*Ta*pb); 
 
end Ex4_2;

//===================================================================================================
