//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 5: Incompressible Flow in Pipes and Channels
//Example  : 5.1 Pg 116
//Title: Turbulent flow in pipes and channels.
//================================================================================================

package Ex5_1
model Ex5_1_1
//===================
// Parameter Section

parameter Real T(unit = "K") = 50             "Temperature of water";
parameter Real d(unit = "ft") = 0.25          "Inside Diameter of pipe";
parameter Real v(unit = "ft/s") = 8           "velocity of water";
parameter Real l(unit = "ft") = 100           "Length of pipe";
parameter Real gc(unit = "ft/s^2") = 32.174   "Acceleration due to gravity";
parameter Real rho(unit = "lb/ft^3") = 62.42  "Density of water";
parameter Real mu(unit = "cP") = 1.31         "Viscosity of water";
parameter Real f(unit = "no unit") = 0.0041   "friction factor";

//===================
// Variable Section 

Real deltap(unit = "lb/ft^2")  "Pressure drop developed";
Real Re(unit = "no unit")      "Reynolds Number";



//==================
// Equation  Section 
 equation
 Re=(d*v*rho)/(mu*6.72*10^(-4));  //Re obtained is 141812. In Textbook its given as 1.4*10^5;
 deltap = (2*f*rho*v^2*l)/(d*gc);
 
end Ex5_1_1;

model Ex5_1_2

//===================
// Parameter Section

parameter Real T(unit = "K") = 50             "Temperature of water";
parameter Real d(unit = "ft") = 0.25          "Inside Diameter of pipe";
parameter Real v(unit = "ft/s") = 8           "velocity of water";
parameter Real l(unit = "ft") = 100           "Length of pipe";
parameter Real gc(unit = "ft/s^2") = 32.174   "Acceleration due to gravity";
parameter Real rho(unit = "lb/ft^3") = 62.42  "Density of water";
parameter Real mu(unit = "cP") = 1.31         "Viscosity of water";
parameter Real f(unit = "no unit") = 0.0041   "friction factor";

//===================
// Variable Section 

Real deltap(unit = "lb/ft^2")  "Pressure drop developed";
Real v1(unit = "ft/s")         "Velocity of water";


//==================
// Equation  Section 
 equation
 deltap = (2*f*rho*v^2*l)/(d*gc);
 (v1/8)^1.8 = 2/(deltap/12^2);    //deltap is converted from lb/ft^2 to lb/in^2, New v1 is found out              
                                  //with respect to a pressure of 2lb/in^2
 
end Ex5_1_2;


end Ex5_1;
