//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 6: Flow of Compressible Fluids.
//Example  : 6.1 Pg 144
//Title: Isentropic flow through nozzles. 
//================================================================================================

package Ex6_1
model Ex6_1_1
//===================
// Parameter Section
parameter Real T0(unit = "K")= 555.6                         "Temperature of air";
parameter Real P0(unit = "atm")= 20                          "Pressure of air";
parameter Real R(unit = "atm.m^3/Kgmol.K")= 82.056*10^(-3)  "Gas constant";
parameter Real M(unit = "nil")= 29                          "Molecular weight";
parameter Real gamma(unit = "nil")= 1.4                     "Gamma of air";
parameter Real Ma(unit = "nil")= 0.8                        "Mach number in the throat";
parameter Real rc(unit="nil")=0.528                         "Constant";

//===================
// Variable Section
Real Tt(unit="K")                       "Temperature";
Real ut(unit="(m/s)")                   "Linear velocity";
Real Pt(unit="atm")                     "Pressure";
Real Gt(unit="Kg/m^2.s")                "Mass velocity";
Real rho0(unit="kg/m^3")                "Density of air";
Real rhot(unit="kg/m^3")                "Density";

//==================
//Equation  Section 
equation
(Pt/20)=0.656 ;  //(1/(1+((1.4-1)/2)*Ma^2)^(1-(1/1.4)))=0.656;
ut=sqrt(2*1.4*R*T0/(M*0.4))*sqrt(1-(Pt/20)^0.28572)*sqrt(1.01325*10^5);                               //it's converted to m/s & (1-(1/1.4))=0.28572
rho0= (20*29)/(R*T0);
rhot= rho0*(Pt/P0)^(1/1.4);
Gt=rhot*ut;
Tt=T0*(Pt/P0)^(1-(1/1.4));

end Ex6_1_1;

model Ex6_1_2
//===================
// Parameter Section
parameter Real T0(unit = "K")= 555.6                         "Temperature of air";
parameter Real P0(unit = "atm")= 20                          "Pressure of air";
parameter Real R(unit = "atm.m^3/Kgmol.K")= 82.056*10^(-3)  "Gas constant";
parameter Real M(unit = "nil")= 29                          "Molecular weight";
parameter Real gamma(unit = "nil")= 1.4                     "Gamma of air";
parameter Real Ma(unit = "nil")= 0.8                        "Mach number in the throat";
parameter Real rc(unit="nil")=0.528                         "Constant";

//===================
// Variable Section
Real rho0(unit="kg/m^3")                   "Density of air";
Real Tstar(unit="K")                       "Temperature at rerservoir conditions";
Real ustar(unit="(m/s)")                   "Linear velocity at reservoir conditions";
Real Pstar(unit="atm")                     "Pressure at reservoir conditions";
Real Gstar(unit="Kg/m^2.s")                "Mass velocity at reservoir conditions";
Real rhostar(unit="kg/m^3")                "Density at reservoir conditions";

//==================
//Equation  Section 
equation
rho0= (20*29)/(R*T0);
Pstar= rc*P0;
Tstar=T0*(2/(1+1.4));
rhostar= rho0*(rc)^(1/1.4);
Gstar=sqrt(2*1.4*rho0*P0*1.01325*(10^5)/0.4)*rc^(1/1.4)*sqrt(1-(rc^(1-(1/1.4))));
ustar=(Gstar/rhostar);

end Ex6_1_2;

model Ex6_1_3
//===================
// Parameter Section
parameter Real T0(unit = "K")= 555.6                         "Temperature of air";
parameter Real P0(unit = "atm")= 20                          "Pressure of air";
parameter Real R(unit = "atm.m^3/Kgmol.K")= 82.056*10^(-3)  "Gas constant";
parameter Real M(unit = "nil")= 29                          "Molecular weight";
parameter Real gamma(unit = "nil")= 1.4                     "Gamma of air";
parameter Real Ma(unit = "nil")= 0.8                        "Mach number in the throat";
parameter Real rc(unit="nil")=0.528                         "Constant";
parameter Real rho0(unit="Kg/m^3")=12.72                    "Density";

//===================
// Variable Section
Real Gr(unit="Kg/m^2")                  "Mass velocity at discharge";
Real Mar(unit = "nil")                  "Mach number at discharge";
Real X(unit="nil")                      "Variable to represent Pr/P0";
Real Gstar(unit="Kg/m^2.s")             "Mass velocity at reservoir conditions";

//==================
//Equation  Section 
equation
Gstar=sqrt(2*1.4*rho0*P0*1.01325*(10^5)/0.4)*rc^(1/1.4)*sqrt(1-(rc^(1-(1/1.4))));
Gr=Gstar/2; //Gr=1738 ,it is found out by solving the above equation
1738= 13432.77931*sqrt(1-(X)^(0.28572))*(X)^(1/1.4);                                             
//sqrt(((2*1.4*rho0*P*1.01325*(10^5))/0.4)=13432.77931.
Mar= sqrt(((2/(1.4-1))*((1/((X)^(1-(1/1.4)))) - 1)));

end Ex6_1_3;


end Ex6_1;
