//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 7: Flow past Immersed objects.
//Example  : 7.1 Pg 172
//Title: Motion of particles through fluids. 
//================================================================================================

package Ex7_1
model Ex7_1_1

//===================
// Parameter Section
parameter Real Dp1(unit ="mm")=0.147          "Diameter for 100 mesh";
parameter Real Dp2(unit ="mm")=0.175          "Diameter for 80 mesh";
parameter Real rhop(unit ="Kg/m^3")=2800      "Density of partcile";
parameter Real Dpavg(unit ="mm")=0.161        "Average Dp";
parameter Real mu(unit ="cP")=0.801           "Viscosity of water";
parameter Real rho(unit ="Kg/m^3")=995.7      "Density of water";
parameter Real g(unit ="m/s^2")=9.80665       "Acceleration due to gravity";

//===================
// Variable Section
Real K(unit="nil")              "It denotes the regime";
Real ut(unit="m/s")             "Terminal settling velocity";
Real Rep(unit="nil")            "Reynolds number";
Real ut1(unit="m/s")             "Terminal settling velocity";
Real Rep1(unit="nil")            "Reynolds number";



//==================
//Equation  Section 
equation
K= Dpavg*10^(-3)*(g*rho*(rhop-rho)/(mu*10^(-3))^2)^(1/3);
ut=((4*g*(rhop-rho)*(Dpavg*10^(-3)))/(3*14*rho))^0.5;
Rep= (Dpavg*10^(-3)*ut*rho)/(mu*10^(-3));
ut1=ut*(14/20)^0.5; //For Re=2.5 CD=20.
Rep1=Rep*(ut1/ut);


end Ex7_1_1;

model Ex7_1_2
//===================
// Parameter Section
parameter Real Dp1(unit ="mm")=0.147          "Diameter for 100 mesh";
parameter Real Dp2(unit ="mm")=0.175          "Diameter for 80 mesh";
parameter Real rhop(unit ="Kg/m^3")=2800      "Density of partcile";
parameter Real Dpavg(unit ="mm")=0.161        "Average Dp";
parameter Real mu(unit ="cP")=0.801           "Viscosity of water";
parameter Real rho(unit ="Kg/m^3")=995.7      "Density of water";
parameter Real g(unit ="m/s^2")=9.80665       "Acceleration due to gravity";
parameter Real CD(unit="nil")=4.1             "Coefficient";

//===================
// Variable Section
Real ut(unit="m/s")             "Terminal settling velocity";
Real Rep(unit="nil")            "Reynolds number";

//==================
//Equation  Section 
equation
ut=(4*g*50*(rhop-rho)*Dpavg*10^(-3)/(3*CD*rho))^0.5;
Rep=(Dpavg*10^(-3)*ut*rho)/(mu*10^(-3));

end Ex7_1_2;

end Ex7_1;
