//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 7: Flow past Immersed objects.
//Example  : 7.3 Pg 184
//Title: Fluidization. 
//================================================================================================

model Ex7_3
//===================
// Parameter Section
parameter Real rho(unit="g/cm^3")=1.24        "Density of particles";
parameter Real epsilon(unit="nil")=0.4        "voidage";
parameter Real d(unit="cm")=0.11              "Diameter of particle";
parameter Real mu(unit="P")=0.01              "viscosity";
parameter Real rho1(unit="g/cm^3")=1.0        "Density of water";
parameter Real g(unit="cm/s^2")=980             "Acceleration due to gravity";
parameter Real l1(unit="nil")=1.25            "25% Expansion takes place ";
parameter Real epsilon1(unit="nil")=0.52       "voidage";


//===================
// Variable Section
Real V0M(unit="cm/s")             "Fluidization velocity";
Real Rep(unit="nil")            "Reynolds number";
Real V0(unit="cm/s")            "Velocity Required for bed expansion";

//==================
//Equation  Section 
equation
(g*(rho-rho1))=((150*mu*V0M*0.6)/(0.11^(2)*0.4^(3)))+ ((1.75*1*V0M^(2))/(0.11*0.4^(3)));
Rep=(d*V0M*rho)/mu;
(epsilon1/epsilon)^(3.9) =(V0/V0M);


end Ex7_3;
