//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 8: Transportation and metering of fluids.
//Example  : 8.1 Pg 205
//Title: Pipe,Fittings and valves. 
//================================================================================================

package Ex8_1
model Ex8_1_1
//===================
// Parameter Section
//For this  problem , Figure 8.5 Pg202 should be referred.

parameter Real T(unit="K")=100          "Temperture of benzene";
parameter Real q(unit="gal/min")=40     "Flowrate of benzene";
parameter Real P1(unit="lb/in^2")=14.7  "Atmospheric pressure";
parameter Real P2(unit="lb/in^2")=50    "Gauge pressure";
parameter Real Z1(unit="ft")=4          "Height at which the pump is kept";
parameter Real Z2(unit="ft")=10         "Height of the discharge";
parameter Real alpha2(unit="nil")=1     "Kinetic energy correction factor";
parameter Real Eta(unit="nil")=0.6      "Mechanical efficiency";
parameter Real g(unit="ft/s^2")=32.17   "Acceleration due to gravity";
parameter Real gc(unit="ft/s^2")=32.17  "Newtons law proportionality factor";
parameter Real rho(unit="lb/ft^3")=54   "Density of benzene";
parameter Real Pv(unit="lb/in^2")=3.8   "Vapour prssure of benzene";
parameter Real hf1(unit="lb/in^2")=0.5  "Friction in suction line";
parameter Real hf2(unit="lb/in^2")=5.5  "Friction in discharge line";
parameter Real deltaH(unit="ft.lb/lb")=479.9 "Enthalpy difference";

//===================
// Variable Section
Real Vb(unit="ft/s")     "Velocity at point 2";
Real x(unit="ft.lb/lb")  "Variable to represent developed Head i.e. Wp*eta";

//==================
//Equation  Section 
equation
Vb= 40/6.34;  
//6.34 is obtained from App.3 Pg1090 for 1.5in 40 Sc pipe, velocity of 1ft/s corresponds to flow rate of 6.34 gal/min
x= ((P1+P2)*144/rho)+((g/gc)*Z2)+((Vb^2)/(2*gc))+((hf1+hf2)*144/rho)-((P1*144)/rho); 
// 144 is multiplied for unit coversion.

end Ex8_1_1;

model Ex8_1_2
//===================
// Parameter Section
//For this  problem , Figure 8.5 Pg202 should be referred.

parameter Real T(unit="K")=100          "Temperture of benzene";
parameter Real q(unit="gal/min")=40     "Flowrate of benzene";
parameter Real P1(unit="lb/in^2")=14.7  "Atmospheric pressure";
parameter Real P2(unit="lb/in^2")=50    "Gauge pressure";
parameter Real Z1(unit="ft")=4          "Height at which the pump is kept";
parameter Real Z2(unit="ft")=10         "Height of the discharge";
parameter Real alpha2(unit="nil")=1     "Kinetic energy correction factor";
parameter Real Eta(unit="nil")=0.6      "Mechanical efficiency";
parameter Real g(unit="ft/s^2")=32.17   "Acceleration due to gravity";
parameter Real gc(unit="ft/s^2")=32.17  "Newtons law proportionality factor";
parameter Real rho(unit="lb/ft^3")=54   "Density of benzene";
parameter Real Pv(unit="lb/in^2")=3.8   "Vapour prssure of benzene";
parameter Real hf1(unit="lb/in^2")=0.5  "Friction in suction line";
parameter Real hf2(unit="lb/in^2")=5.5  "Friction in discharge line";

//===================
// Variable Section
Real m(unit="lb/s")      "Mass flow rate";
Real PB(unit="hp")       "Power developed";
Real Wp(unit="ft.lb/lb") "Developed Head";
Real Vb(unit="ft/s")     "Velocity at point 2";

//==================
//Equation  Section 
equation
Vb= 40/6.34;
(Wp*Eta)= ((P1+P2)*144/rho)+((g/gc)*Z2)+((Vb^2)/(2*gc))+((hf1+hf2)*144/rho)-((P1*144)/rho); 
// 144 is multiplied for unit coversion.
m= (40*rho)/(7.48*60); 
PB= (m*Wp*Eta)/(550*Eta);


end Ex8_1_2;

model Ex8_1_3
//===================
// Parameter Section
//For this  problem , Figure 8.5 Pg202 should be referred.

parameter Real T(unit="K")=100          "Temperture of benzene";
parameter Real q(unit="gal/min")=40     "Flowrate of benzene";
parameter Real P1(unit="lb/in^2")=14.7  "Atmospheric pressure";
parameter Real P2(unit="lb/in^2")=50    "Gauge pressure";
parameter Real Z1(unit="ft")=4          "Height at which the pump is kept";
parameter Real Z2(unit="ft")=10         "Height of the discharge";
parameter Real alpha2(unit="nil")=1     "Kinetic energy correction factor";
parameter Real Eta(unit="nil")=0.6      "Mechanical efficiency";
parameter Real g(unit="ft/s^2")=32.17   "Acceleration due to gravity";
parameter Real gc(unit="ft/s^2")=32.17  "Newtons law proportionality factor";
parameter Real rho(unit="lb/ft^3")=54   "Density of benzene";
parameter Real Pv(unit="lb/in^2")=3.8   "Vapour prssure of benzene";
parameter Real hf1(unit="lb/in^2")=0.5  "Friction in suction line";
parameter Real hf2(unit="lb/in^2")=5.5  "Friction in discharge line";


//===================
// Variable Section
Real NPSHa(unit="ft")    "NPSH available";

//==================
//Equation  Section 
equation
NPSHa= ((P1*144)/rho)-((Pv*144)/rho)-((hf1*144)/rho)-Z1;


end Ex8_1_3;

end Ex8_1;
