//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 8: Transportation and metering of fluids.
//Example  : 8.2 Pg 215
//Title: Fans,blowers and compressors. 
//================================================================================================

model Ex8_2
//===================
// Parameter Section

parameter Real P1(unit="inHg")=29       "Suction pressure";
parameter Real P2(unit="inHg")=30.1     "Discharge pressure";
parameter Real Pstd(unit="inHg")=29.92  "Standard pressure";
parameter Real T(unit="F")=200          "Temperature";
parameter Real Tstd(unit="F")=32        "Standard temperature";
parameter Real Eta(unit="nil")=0.65     "Efficiency of the fan";
parameter Real M(unit="lb/lbmol")=31.3  "Molecular weight of gas";
parameter Real V2(unit="ft/s")=150      "Discharge velocity";
parameter Real q(unit="ft^3/min")=10000 "Flowrate of gas";
parameter Real gc(unit="ft/s^2")=32.17  "Newtons law proportionality factor"; 

//===================
// Variable Section
Real rhoa(unit="lb/ft^3")      "Suction density";
Real rhob(unit="lb/ft^3")      "Discharge density";
Real rhoavg(unit="lb/ft^3")    "Average density";
Real m(unit="lb/s")            "Mass flow rate";
Real Wp(unit="ft.lb/lb")       "Developed Head";
Real PB(unit="hp")              "Power developed";

//==================
//Equation  Section 
equation
rhoa= (M*P1*(460+Tstd))/(359*Pstd*(460+T)); 
//359 is the molal volume for 32 F and 460 is added for conversion to Rankin scale.
rhob= rhoa*(P2/P1);
rhoavg= (rhoa+rhob)/2;
m= (q*M)/(359*60);
Wp= (1/Eta)*((((P2-P1)*144*14.7)/(Pstd*rhoavg))+(V2^2/(2*gc)));
PB= (m*Wp)/550;

end Ex8_2;
