//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 8: Transportation and metering of fluids.
//Example  : 8.3 Pg 222
//Title: Fans,blowers and compressors. 
//================================================================================================

model Ex8_3
//===================
// Parameter Section

parameter Real q(unit="ft^3/min")=180        "Flowrate of methane";
parameter Real Cp(unit="Btu/lb.mol F")=9.30   "Specific heat";
parameter Real P2(unit="lb/in^2")=900        "Final pressure";
parameter Real P1(unit="lb/in^2")=14         "Initial pressure";
parameter Real T(unit="F")=80                "Inlet temperature";
parameter Real Eta(unit="nil")=0.8           "Mechanical efficiency";
parameter Real gamma(unit="nil")=1.31        "Ratio of specific heat";

//===================
// Variable Section
Real PB(unit="hp")    "Power required";
Real Ptot(unit="hp") "Total Power required";
Real TB(unit="R")    "Discharge temperaure";
Real m(unit="lb.mol/h")  "Mass flow rate"; 
Real q1(unit="Btu/h")"Heat load";
Real Q1(unit="lb/h") "Cooling water requirement"; 

//==================
//Equation  Section 
equation
PB= ((T+460)*(1.304*10^(-4))*1.31*180/((gamma-1)*Eta))*(4^(1-(1/1.31))-1);
// 460 is added for conversion to rankin scale and (pa/pb)=4=compression ratio.
Ptot= 3*PB;
TB=(T+460)*(4^(1-(1/1.31)));
m= (q*60)/359; //  1lb.mol=359 ft^3. It is converted.
q1= ((TB-460)-T)*Cp*m; //This value is for single stage.
Q1= (3*q1)/20; // 3 is multiplied because it is 3 stage compressor.

//The value of q1 and Q1 changes slightly due to round off error.

end Ex8_3;
