//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 8: Transportation and metering of fluids.
//Example  : 8.5 Pg 238
//Title: Measurement of flowing fluids. 
//================================================================================================

model Ex8_5
//===================
// Parameter Section
parameter Real T(unit="F")=200          "Temperature of air";
parameter Real Cp(unit="nil")=0.98      "Coefficient of pitot tube";
parameter Real P1(unit="inHg")=29.92    "Barometric pressure";
parameter Real Psta(unit="inHg")=15.25  "Static pressure";
parameter Real M(unit="lb/lbmol")=29    "Molecular weight of air";
parameter Real x(unit="in")=0.54        "Manometer reading";
parameter Real mu(unit="cP")=0.022      "Viscosity";

//===================
// Variable Section
Real deltaP(unit="lb/ft^2")"Pressure difference. That is ps-po";
Real Pabs(unit="inHg")     "Absolute pressure";
Real rho(unit="lb/ft^3")   "Density";
Real umax(unit="ft/s")     "Maximum velocity";
Real Remax(unit="nil")     "Reynolds number based on maximum velocity";
Real Vbar(unit="ft/s")     "Average fluid velocity";
Real q(unit="ft^3/min")    "Volumetric flowrate";

//==================
//Equation  Section 
equation
Pabs= P1+ (Psta/13.6);
rho=(M*492*Pabs)/(359*P1*(460+200)); // 460 is added to convert it to Rankin scale.
deltaP= (0.54/12)*62.37;
umax=0.98*sqrt(2*32.174*(2.81/rho));
Remax= ((36/12)*umax*rho)/(mu*0.000672); 
//The value is 670000 in textbook.Here we get 668387 due to round off error.
Vbar= 0.86*umax; //From Fig5.8 Pg 113 we get the value of 0.86 for the Re obtained.
q=Vbar*(36/12)^2*(3.1415/4)*(Pabs/P1)*(520/660)*60;

end Ex8_5;
