//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 9: Agitation and mixing of liquids
//Example  : 9.2 Pg 263
//Title: Agitated vessels.
//================================================================================================

model Ex9_2
//===================
// Parameter Section
parameter Real D1(unit="m")=2          "Diameter of tank";
parameter Real D2(unit="m")=0.67       "Diameter of turbine";
parameter Real n(unit="r/s")=1.5       "Speed of turbine";
parameter Real rho(unit="kg/m^3")=1120 "Density";
parameter Real mu(unit="Pa.s")=120     "Viscosity";
parameter Real Kl(unit="nil")=65       "Constant";

//===================
// Variable Section
Real Re(unit="nil")   "Reynolds number";
Real P(unit="W")      "Power required";

//==================
//Equation  Section 
equation
Re= D2^2*rho*n/mu;
P=Kl*mu*D2^3*n^2;

end Ex9_2;
