//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 9: Agitation and mixing of liquids
//Example  : 9.4 Pg 275
//Title: Suspension of solid particles.
//================================================================================================

package Ex9_4

model Ex9_4_1
//===================
// Parameter Section
parameter Real D(unit="ft")=6           "Vessel diameter";
parameter Real h(unit="ft")=8           "Working depth";
parameter Real Pchange(unit="hp")=1.55  "Change in power";
parameter Real P2(unit="hp")=3.3        "For fluorspar"; //1.55*2.1. From fig 9.20 Pg274.
parameter Real Kt(unit="nil")=1.27      "Constant obtained form table 9.2";
parameter Real sg(unit="nil")=3.18      "Specific gravity";

//===================
// Variable Section
Real V(unit="ft^3")     "Volume";
Real P(unit="hp")       "Power";

//==================
//Equation  Section 
equation
V=(1/4)*3.1415*D^2*h*7.48;
P= 3.3*(1692/1000);

end Ex9_4_1;

model Ex9_4_2
//===================
// Parameter Section
parameter Real D(unit="ft")=6           "Vessel diameter";
parameter Real h(unit="ft")=8           "Working depth";
parameter Real Pchange(unit="hp")=1.55  "Change in power";
parameter Real P2(unit="hp")=3.3        "For fluorspar"; //1.55*2.1. From fig 9.20 Pg274.
parameter Real Kt(unit="nil")=1.27      "Constant obtained form table 9.2";
parameter Real sg(unit="nil")=3.18      "Specific gravity";

//===================
// Variable Section
Real nc(unit="r/s")      "Rotating speed";
Real rhom(unit="lb/ft^3")"Density of slurry";
Real P(unit="hp")       "Power";

//==================
//Equation  Section 
equation
P= 3.3*(1692/1000);
rhom= 1/((0.25/3.18)+0.75) *62.42;
nc=((P*550*32.17)/(1.27*rhom*2^5))^(1/3);

end Ex9_4_2;

end Ex9_4;
