model Ex10_1
  //Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015
  //Chapter-10 : Fluid machinery
  //Example: 10.1   Page:502
  //Topic: Idealized centrifugal flow
  //===================================================================================
  //=======================================================
  //Parameter Section
  parameter Real p(unit = "kg/m^3") = 1000 "Density of water";
  parameter Real r2(unit = "mm") = 50 "Radius of impeller";
  parameter Real vr2(unit = "m/s") = 3 "Speed of impeller";
  parameter Real q(unit = "m^3/s") = 0.009 "Flowrate of water";
  parameter Real w(unit = "rad/s") = 360 "Speed of impeller";
  parameter Real c1(unit = "m/mm") = 1E-3 "Unit conversion constant";
  parameter Real c2(unit = "N*s^2/(kg*m)") = 1 "Unit conversion constant";
  parameter Real c3(unit = "W*s/(N*m)") = 1 "Unit conversion constant";
  final constant Real pi = 2 * Modelica.Math.asin(1.0);
  //=======================================================
  //Variable Section
  Real b2(unit = "m") "Impeller exit width";
  Real ts(unit = "N*m") "Torque input";
  Real wm(unit = "W") "Power predicted";
  //=======================================================
  //Equation Section
equation
  b2 = q / (2 * pi * r2* c1 * vr2) "Expression for b2 ";
  ts = w * (r2 * c1) ^ 2 * p * q * c2 "Expression for ts";
  wm = w * ts * c3 "Expression for wm";
  annotation(experiment(StartTime = 0, StopTime = 6000, Tolerance = 1e-06, Interval = 12));
end Ex10_1;
