//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-10 : Fluid machinery
//Example: 10.18   Page:575
//Topic: Performance of a ideal windmill
//===================================================================================
model Ex10_18

//============================================================
//Parameter Section
parameter Real d(unit="m")=26"Diameter";
parameter Real n(unit="rev/min")=20"Rotational speed";
parameter Real v(unit="km/hr")=36"Speed of the air in windmill";
parameter Real po(unit="kW")=41"Power output";
parameter Real a(unit="")=1/3"Interference Factor";
parameter Real a1(unit="")=0.5"Corrected Interference factor";
parameter Real p(unit="kg/m^3")=1.23"Density of air";
parameter Real c1(unit="rad* min/rev*s")=2*pi/60"Unit conversion factor";
parameter Real c2(unit="m*hr/(km*s)")=1/3.6"unit conversion constant";
parameter Real c3(unit="N*s^2/(kg*m)")=1"Unit conversion constant";
parameter Real c4(unit="W*s/(N*m)")=1"unit conversion constant";
parameter Real c5(unit="kW/W")=1e-3"unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//============================================================
//Variable Section 
Real x(unit="")"Tip-Speed ratio";
Real kef(unit="W")"kinetic energy flux";
Real na(unit="")"Actual efficiency";
Real kx(unit="N")"maximum possible thrust";

//============================================================
//Equation Section
equation
x=n*d*0.5*c1/(v*c2)"equation for x";
kef=0.5*p*c5*c3*c4*(v*c2)^3*0.25*pi*d^2"Expression for kef";
na=po/kef"Expression for na";
kx=0.25*p*(v*c2)^2*pi*d^2*2*a1*(1-a1)*c3"Expresion for kx";
end Ex10_18;
//============================================================
