//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-10 : Fluid machinery
//Example: 10.2   Page:509
//Topic: Comparision of specific speed definitions
//===================================================================================
model Ex10_2

//============================================================
//Parameter Section
parameter Real d(unit="m")=0.2"Diameter of impeller";
parameter Real H(unit="m")=7"Head generated by pump";
parameter Real q(unit="m^3/hr")=68"Volumetric flow rate";
parameter Real N(unit="rpm")=1170"Speed of the pump";
parameter Real w(unit="rpm")=1170"Speed of the pump";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real c1(unit="rev/(rpm*s)")=2/60"Unit conversion constant";
parameter Real c2(unit="s/hr")=3600"Unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section
Real nscu(unit="")"Dimensionless specific speeds";
Real ns(unit="")"Engineeering specific speeds";
Real h(unit="m^2/s^2")"Energy per unit mass";
Real r(unit="")"Ratio between dimensionleass and engineering specific speeds";

//=======================================================
//Equation Section
equation
nscu=w*q^0.5/(H)^0.75"Expression for dimesionless specific speed";
ns=N*c1*pi*(q/c2)^0.5/(h)^0.75"Expression for engineering specific speed";
h=g*H"Expresion for energy per unit mass";
r=nscu/ns"Ratio between dimensionless specific speed and engineering specific speed";
end Ex10_2;
//========================================================
