model Ex12_5
  //Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015
  //Chapter-12 : Introduction to compressible flow
  //Example: 12.5   Page:678
  //Topic: Local isoentropic coonsition in stagnation conditions in channel flow
  //===================================================================================
  //=======================================================
  //Parameter Section
  parameter Real k(unit = "") = 1.4 "Constant ";
  parameter Real R(unit = "N*m/(kg*K)") = 287 "Universal gas constant ";
  parameter Real t1(unit = "K") = 333 "Temperature";
  parameter Real v1(unit = "m/s") = 183 "Speed at which a air flows";
  parameter Real p1(unit = "kPa") = 350 "Pressure in zone-1";
  parameter Real p02(unit = "kPa") = 385 "Isoentropic stagnation pressure in zone-2";
  parameter Real t02(unit = "K") = 350 "Isoentropic stagnation temperature in zone-2";
  parameter Real cp(unit = "kJ/(kg*K)") = 1 "Heat capacity at constant pressure";
  parameter Real c1(unit = "kg*m/(N*s^2)") = 1 "Unit conversion constant";
  parameter Real c2(unit = "kJ/J") = 1E-3 "Unit conversion constant";
  parameter Real m2(unit = "")=1.3 "Mach number at section-2";
  //=======================================================
  //Variable Section
  Real c(unit = "m/s") "Velocity of air at temperature t1";
  Real m1(unit = "") "Mach number at section-1";
  Real p01(unit = "kPa") "Local isoentropic stagnation pressure";
  Real t01(unit = "K") "Local isoentropic temperature";
  Real p2(unit = "kPa") "Pressure at zone-2";
  Real t2(unit = "K") "Temperaure in zone-2";
  Real s21(unit = "kJ/(kg*k)") "Change in entropy";
  //=======================================================
  //Equation Section
equation
  c = sqrt(k * R * t1 * c1) "Expression for c at section-1";
  m1 = v1 / c "Expression for mach number";
  p01 = p1 * (1 + ((k - 1)* m1^2)/2)^(k/(k - 1)) "Expression for p01";
  t01 = t1 * (1 + (k - 1) * 0.5 * m1 ^ 2) "Expression for t01";
  p2 = p02 / (1 + ((k - 1)*m2^2)/2)^(k/(k - 1)) "Expression for p2";
  t2 = t02 / (1 + ((k - 1)*m2^2/2)) "Expression for t2";
  s21 = cp * log(t2 / t1) - (R * c1 * log(p2 / p1)/1000) "Expression for s21";
  annotation(experiment(StartTime = 0, StopTime = 6000, Tolerance = 1e-06, Interval = 12));
end Ex12_5;
//========================================================================================
//Remark: the value of s21 given in the book is an approximated one so answer from this model and the book will differ by a small value. 
