//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015 

//Chapter-2 : Fundamental Concepts
//Example: 2.3   Page 37
//Topic: Analysis of Capillary Effect in a tube
//=======================================================================
model Ex2_3

//======================================================
// Parameter Section
parameter Real pw(unit="kg/m^3")=1000"Density of water";
parameter Real pm(unit="kg/m^3")=13600"Density of mercury";  
parameter Real phiw(unit="N/m")=72.8E-3"Surface Tension of water";
parameter Real phim(unit="N/m")=484E-3"Surface Tension of mercury ";
parameter Real thetaw(unit="")=0"Angle in case of water";
parameter Real thetam(unit="")=140"Angle in case of mercury";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real c1(unit="N/(kg*m/s^2)")=1"Conversion Factor";
final constant Real D2R=3.141592654/180 "Degrees to Radians";

//======================================================
// Variable Section
Real hw(unit="m")"Capillary Height in case of water";
Real hm(unit="m")"Capillary height in case of mercury";
Real dm(unit="m")"Diameter of mercury column so that deltaH is less than 1 mm";
Real dw(unit="m")"Diameter of water column so that deltaH is less than 1 mm";


//======================================================
// Equation Section
equation
 hw=1E-3"Diameter of column is to be computed for a Delta H of o.oo1m";
 hm=-(1E-3)"Diameter of column is to be computed for a Delta H of o.oo1m";
 hw=4*phiw*cos(D2R*thetaw)/(c1*pw*g*dw)"Expression for finding Dw";
 hm=4*phim*cos(D2R*thetam)/(c1*pm*g*dm)"Expression for finding Dm";
end Ex2_3;
//======================================================
