//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015 

//Chapter-3 : Pressure Variation in a Static Fluid
//Example: 3.3    Page:65
//Topic: Multiple-Liquid Manometer 
//=======================================================================
model Ex3_3

//======================================================
// Parameter Section
parameter Real d1(unit="in")=10"Difference in Elevation between Pipe A and point C";
parameter Real d2(unit="in")=3"Difference in Elevation between points C and D";
parameter Real d3(unit="in" )=4"Difference in Elevation between points D and E";
parameter Real d4(unit="in" )=5"Difference in Elevation between points E and F";
parameter Real d5(unit="in" )=8"Difference in Elevation between point F and Pipe B";
parameter Real g(unit="m^2/s")=9.81"Acceleration due to Gravity";
parameter Real dw(unit="kg/m^3")=1000"Density of Water";
parameter Real c1(unit="m/in")=2.5E-2"Constant for Unit Conversion";
parameter Real c2(unit="N*s^2/(kg*m)")=1"Constant for Unit Conversion";
parameter Real c3(unit="kPa*m^2/N")=1e-3"Unit conversion constant";
parameter Real s1(unit="")=13.6"Specific Gravity of Mercury";
parameter Real s2(unit="")=0.88"Specific Gravity of oil";

//======================================================
// Variable Section
Real Pab(unit="kPa")"Pressure Difference Pa-Pb";

//======================================================
// Equation Section
equation
Pab=g*dw*c2*c3*((-d1*c1)+(s1*d2*c1)-(s2*d3*c1)+(s1*d4*c1)+(d5*c1))"Expression for Evaluating Pab"; 
end Ex3_3;
//======================================================
