//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  

//Chapter-3 : Pressure Variation in a Static Fluid
//Example: 3.4    Page:68
//Topic: Pressure and Density variation in the Atmosphere 
//=======================================================================
model Ex3_4


//======================================================
// Parameter Section
parameter Real zo(unit="m")=1610"Elevation in Denver ";
parameter Real z(unit="m")=3230"Elevation in Vail Pass";
parameter Real po(unit="mm Hg")=630"Barometric Pressure in Denver";
parameter Real to(unit="K")=300"Temperature in Denver";
parameter Real t(unit="K")=290"Temperature in Vail Pass";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to Gravity";
parameter Real R(unit="J/(kg*K)")=286.9"Universal Gas Constant";
parameter Real c1(unit="N*s^2*J/(kg*m^2*N)")=1"Unit Conversion Factor";
parameter Real k(unit="")=1.4"Constant used in Adiabatic Conditions";

//======================================================
// Variable Section
Real m(unit="K/m")"constant";
Real p(unit="mm Hg")"Barometric Pressure in Vail Pass(Assuming Temp. varies with Altitude linearly)";
Real p1(unit="mm Hg")"Barometric Pressure in Vail Pass(Assuming constant density)";
Real p2(unit="mm Hg")"Barometric Pressure in Vail Pass(Assuming Temperature to be constant)";
Real p3(unit="mm Hg")"Barometric Pressure in Vail Pass(Assuming an Adiabatic Atmosphere)";
Real d(unit="")"% Change in Density in Vail Pass(Assuming Temp. varies with Altitude linearly)";
Real d1(unit="")"% Change in Density in Vail Pass (Assuming constant density)";
Real d2(unit="")"% Change in Density in Vail Pass(Assuming Temperature to be constant)";
Real d3(unit="")"% Change in Density in Vail Pass(Assuming an Adiabatic Atmosphere)";
Real c(unit="")"Constant in expression for Barometric Pressure";

//======================================================
// Equation Section
equation
m=(to-t)/(z-zo)"Expression for evaluating constant m";
c=g*c1/(m*R)"Expression for evaluating constant c";
(p/po)=(t/to)^(c)"Expression  for Barometer Pressure(Assuming Temp. varies with Altitude linearly)"; 
d=((p/po*to/t)-1)*100"Expression for % Change in Density in Vail Pass(Assuming Temp. varies with Altitude linearly)";
p1=po*(1-(g*(z-zo)/(R*to)))"Expression  for Barometer Pressure(Assuming constant density)";
d1=0"Expression for % Change in Density in Vail Pass (Assuming constant density)";
p2=po*exp(-g*(z-zo)/(R*to))"Expression  for Barometer Pressure(Assuming Temperature to be constant)";
d2=((p2/po*to/to)-1)*100"Expression for % Change in Density in Vail Pass(Assuming Temperature to be constant)";
p3=po*(t/to)^(k/(k-1))"Expression  for Barometer Pressure(Assuming an Adiabatic Atmosphere)";
d3=((p3/po*to/t)-1)*100"Expression for % Change in Density in Vail Pass(Assuming an Adiabatic Atmosphere)";
end Ex3_4;
//======================================================
