//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  

//Chapter-3 : Pressure Variation in a Static Fluid
//Example: 3.5    Page:72
//Topic: Resultant force on inclined plane submerged surface //=======================================================================
model Ex3_5

//======================================================
// Parameter Section
parameter Real d(unit="m")=2;
parameter Real l(unit="m")=4;
parameter Real w(unit="m")=5;//Width of inclined plane
parameter Real D(unit="kg/m^3")=999;//Density 
parameter Real g(unit="m^2/s")=9.81;//Acceleration due to Gravity
parameter Real k(unit="N*s^2/(kg*m)")=1;//Constant for unit conversion
parameter Real c1(unit="kN/N")=1e-3;//unit conversion constant
//======================================================
// Variable Section
Real Ixx(unit="m^2");//Moment about x-axis
Real A(unit="m^2");//Area
Real yc(unit="m");//Y co-ordinates of centroid 
Real y(unit="m");//Y co-ordinates of Centre of pressure
Real xc(unit="m");//X co-ordinates of Centroid 
Real x(unit="m");//X co-ordinates of Centre of Pressure
Real fr(unit="kN");//Resultant Force

//======================================================
// Equation Section
equation
xc=w/2;//Expression for X Co-ordinate of Centroid 
yc=(d/sin(30*3.14/180))+(0.5*l);//Expression for Y Co-ordinate of Centroid 
y=yc+(Ixx/(A*yc));//Expression for X Co-ordinate of Centre of Pressure 
A=l*w;//Expression for Area
Ixx=(w*l^3)/12;//Expression for moment about X-axis
fr=D*g*w*k*c1*((d*l)+(l^2*0.5*sin(30*3.14/180)));//Expression for Resultant force 
x=xc;//Expression for X co-ordinate of Centre of Pressure
end Ex3_5;
//=============================================================================
