//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  

//Chapter-4 : Basic equations in integral form for a control volume
//Example: 4.3   Page:109
//Topic: Density change in venting tank
//=======================================================================
model Ex4_3

//==============================================================
//Parameter Section
parameter Real v(unit="m^3")=0.05"Volume of Tank";
parameter Real p(unit="kPa")=800"Pressure of air in tank";
parameter Real t(unit="K")=298"Temperature of air";
parameter Real d(unit="kg/m^3")=6"Density of air";
parameter Real a(unit="mm^2")=65"Flow area of valve";
parameter Real u(unit="m/s")=300"Velocity at which air flows the valve";
parameter Real c(unit="m^2/mm^2")=1e-6"Unit conversion constant";

//==============================================================
//Variable Section
Real dc(unit="kg/(m^3*s)")"Instantaneous density change of density in the tank";

//==============================================================
//Equation Section
equation
dc=(-1*d*u*a*c)/v"Expression for instantaneous change in density of air in tank";
end Ex4_3;
//===========================================================================
