model Ex5_11
  //Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015
  //Chapter-5 : Introduction to differenrial analysis of fluid motion
  //Example: 5.11   Page:211
  //Topic: Euler method solution for draining tank
  //=======================================================================
  //=======================================================
  //Parameter Section
  parameter Real D(unit = "mm") = 250 "Diameter of tank";
  parameter Real d(unit = "mm") = 2 "Hole diameter";
  parameter Real yo(unit = "m") = 1 "Initial Height of water in tank";
  parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to  gravity";
  //=======================================================
  //Variable Section
  Real y(unit = "m");
  //=======================================================
  //Equation Section
equation
  y = (sqrt(yo) - (d / D) ^ 2 * sqrt(g / 2) * time) ^ 2 "Expression for actual height of tank";
  annotation(experiment(StartTime = 0, StopTime = 6000, Tolerance = 1e-06, Interval = 12));
end Ex5_11;
