//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-6 : Incompressible invisid flow
//Example: 6.8   Page:256
//Topic: Frictionless flow with heat transfer
//=======================================================================
model Ex6_8

//=======================================================
//Parameter Section
parameter Real z34(unit="m")=3"Difference in elevation between point-3 and point-4";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real d(unit="kg/m^3")=1000"Density of water";
parameter Real a4(unit="mm^2")=560"area of cross section at point-4";
parameter Real q(unit="kW")=10"Power rating of heater";
parameter Real cp(unit="J/(kg*K)")=4179"Specific heat capacity of water";
parameter Real c1(unit="W/kW")=1E3"Unit conversion constant";
parameter Real c2(unit="J/(W*s)")=1"Unit conversion constant";
parameter Real c3(unit="m^2/mm^2")=1E-6"Unit conversion constant";

//=======================================================
//Variable Section
Real m(unit="kg/s")"mass flow rate of water";
Real v4(unit="m/s")"Velocity at point-4";
Real t12(unit="K")"Temperature rise of water";

//=======================================================
//Equation Section
equation
m=d*v4*a4*c3"Expression for mass flow rate of water ";
v4=sqrt(2*g*z34)"Expression for velocity at point-4 ";
t12=q*c1*c2/(m*cp)"Expression for temperature rise";
end Ex6_8;
//===============================================================
