//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-7 : Dimensional analysis and simlitude
//Example: 7.5   Page:312
//Topic: Incomplete similarity: Aerodyanmic drag on bus
//=======================================================================
model Ex7_5

//=======================================================
//Parameter Section
parameter Real v[9](unit="m/s")={18,21.8,26,30.1,35,38.5,40.9,44.1,46.7}"Air velocity data";
parameter Real fd[9](unit="N")={3.1,4.41,6.09,7.97,10.7,12.9,14.7,16.9,18.9}"Drag force data";
parameter Real w(unit="m")=2.44"Width of the prototype";
parameter Real a(unit="m^2")=7.8"Area of the prototype";
parameter Real r(unit="")=1/16"Model scale";
parameter Real p(unit="kg/m^3")=1000"denisty of water";
parameter Real pa(unit="kg/m^3")=1.23"denisty of air";
parameter Real k(unit="m^2/s")=1.46E-5"Kinematic viscosity of water";
parameter Real vp(unit="km/hr")=100"Speed of vehicle";
parameter Real cdp(unit="")=0.46"Drag coefficient of prototype when reynolds number is greater than 4E5";
parameter Real c1(unit="N*s^2/(kg*m)")=1"Unit conversion constant";
parameter Real c2(unit="km*s/(hr*m)")=3.6"Unit conversion constant";
parameter Real c3(unit="kW*s/(N*m)")=1E-3"Unit conversion constant";
parameter Real c4(unit="kN/N")=1E-3"Unit conversion constant";
//=======================================================
//Variable Section
Real wm(unit="m")"Width of the model";
Real am(unit="m^2")"Area of the model";
Real cd[9](unit="")"Drag coefficient of model";
Real re[9](unit="")"Reynolds number of model";
Real fdp(unit="kN")"Drag force acting on a prototype";
Real pp(unit="kW")"Power requirement of the prototype";
//=======================================================
//equation Section
algorithm
wm:=r*w"width of model";
am:=r^2*a"Area of model";
for i in 1:9 loop
  cd[i]:=fd[i]/(c1*(0.5*p*v[i]^2))"Expression for Drag coefficient";
  re[i]:=v[i]*wm/k"Expression for reynolds number ";
end for;
fdp:=cdp*0.5*pa*(vp/c2)^2*a*c4"Expression for drag force on prototype";
pp:=fdp*(vp/c2)*c3*1E3"Expression for power requirement";
end Ex7_5;
//====================================================================
