//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-8 : Internal incompressible viscous flow
//Example: 8.1   Page:336
//Topic: Leakage flow past a piston
//=======================================================================
model Ex8_1

//=======================================================
//Parameter Section
parameter Real d(unit="mm")=25"Diameter of the piston";
parameter Real a(unit="mm")=0.005"Radial Clearance";
parameter Real p1(unit="N/m^2")=20E6"Pressure in hydraulic system";
parameter Real p2(unit="N/m^2")=1E6"Pressure in low pressure side of the piston";
parameter Real m(unit="kg/(m*s)")=0.018"Viscosity of the fluid";
parameter Real l(unit="mm")=15"length of the piston movement";
parameter Real sg(unit="")=0.92"Specific Gravity";
parameter Real p(unit="kg/m^3")=1000"Density of water";
parameter Real c1(unit="m/mm")=1E-3"Unit conversion constant";
parameter Real c2(unit="kg*m/(N*s^2)")=1"Unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section
Real q(unit="mm^3/s")"Flow rate";
Real v(unit="m/s")"Flow velocity";


//=======================================================
//Equation Section
equation
q=pi*d*a^3*(p1-p2)*c2/(12*m*l)"Expression for flow rate";
v=q*c1/(pi*d*a)"Expression for velocity";

end Ex8_1;
//==================================================================================
