//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-8 : Internal incompressible viscous flow
//Example: 8.10   Page:386
//Topic: Use of diffuser to increase flow rate
//=======================================================================
model Ex8_10

//=======================================================
//Parameter Section
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real zo(unit="m")=1.5"Height of tank";
parameter Real d1(unit="m")=0.025"Diameter of tank";
parameter Real ke(unit="")=0.04"Entrance loss coefficient from table 8.2";
parameter Real ar(unit="")=2;
parameter Real nr(unit="")=3"N/R1 ratio";
parameter Real cp(unit="")=0.45"Cp value for N/R1 from figure 8.16";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section 
Real q(unit="m^3/s")"Flowrate at nozzle entrance";
Real v1(unit="m/s")"Velocity at nozzle entrance";
Real v2(unit="m/s")"Velocity at nozzle exit";
Real kd(unit="")"Diffuser loss coefficient";
Real v3(unit="m/s")"Changed value of v1";
Real qd(unit="m^3/s")"Flowrate at nozzle exit";
Real delq(unit="")"Percent change in flowrate";

//=======================================================
//Equation Section
equation
v1=sqrt(2*g*zo/(ke+1))"Expression for v1";
q=v1*pi*d1^2*0.25"Expression for q";
v2=v1/ar"Expression for v2";
kd=1-ar^(-2)-cp"Expression for kd";
v3=sqrt((2*g*zo)/(ke+kd+ar^(-2)))"Expression for v3 ";
qd=v3*0.25*pi*d1^2"Expression for qd";
delq=(qd-q)*100/q"Expression for delq";
end Ex8_10;
//========================================================================
