//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-8 : Internal incompressible viscous flow
//Example: 8.2   Page:341
//Topic: Torque and power in a journal bearing
//=======================================================================
model Ex8_2

//=======================================================
//Parameter Section
parameter Real m(unit="kg/(m*s)")=9.6E-3"Viscosity of SAE-30 oil ";
parameter Real w(unit="rev/min")=3600"Angular velocity of shaft ";
parameter Real d(unit="mm")=76"Diameter of the shaft";
parameter Real a(unit="mm")=31.88"Length of the shaft";
parameter Real c1(unit="rad/rev")=2"Unit converison constant";
parameter Real c2(unit="min/s")=1/60"Unit conversion constant";
parameter Real c3(unit="m/mm")=1E-3"Unit conversion constant";
parameter Real c4(unit="pa*m^2/N")=1"Unit conversion constant";
parameter Real c5(unit="W/(N*m)")=1"Unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section
Real txy(unit="Pa")"Shear force acting on the shaft";
Real t(unit="N*m")"Torque required to turn the shaft";
Real p(unit="W")"Power dissipated in the shaft";

//=======================================================
//Equation Section
equation
txy=m*w*c1*pi*c2*d*c3*c4/(2*a*c3*c3)"Expression for txy";
t=txy*pi*0.5*(d*c3)^2*(a*c3)"Expression for torque";
p=w*c1*pi*c2*t*c5"Expression for power";
end Ex8_2;
//===========================================================================
