//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-8 : Internal incompressible viscous flow
//Example: 8.7   Page:375
//Topic: Flow from a water tower:flowrate unknown
//=======================================================================
model Ex8_7

//=======================================================
//Parameter Section
parameter Real ld(unit="")=2040"L/D ratio";
parameter Real z12(unit="m")=24"Water level in the water tower from pipe ";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real d(unit="m")=100.6E-3"Diameter of the pipe ";
parameter Real n(unit="m^2/s")=1.124E-6"Kinematic viscosity";
parameter Real v1(unit="m/s")=0;
parameter Real ed(unit="")=0.005"Roughness factor";
final constant Real pi=2*Modelica.Math.asin(1.0);
//=======================================================
//Variable Section
Real v2(unit="m/s")"Velocity of fluid";
Real re(unit="")"Reynolds number for associated with the flow";
Real q(unit="m^3/s")"Flow rate of the fluid";
Real f(unit="")"Friction Factor";

//=======================================================
//Equation Section
equation
1/sqrt(f)=-2*log10((ed/3.7)+(2.51/(re*sqrt(f))))"Expresion for evaluating friction factor";
re=v2*d/n"Expression for reynolds number";
q=v2*pi*0.25*d^2"Expression for flow rate";
v2=sqrt(2*g*z12/((f*(ld+8))+1))"Expression  for velocity";
end Ex8_7;
//==========================================================================
