//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015 

//Chapter-1 : Introduction
//Example: 1.4   Page 13
//Topic: Use of Units
//=======================================================================
model Ex1_4

//======================================================
// Parameter Section
parameter Real m1(unit="kg")=0.510"Mass in SI units";
parameter Real k1(unit="kg/lbm")=0.454"Conversion Factor for conversion of mass from SI to EE units";
parameter Real k2(unit="lbm/slug")=32.2"Conversion Factor for conversion of mass from EE to BG units";
parameter Real g1(unit="m/s^2")=9.81"Value of Acceleration due to Gravity in SI units";
parameter Real g2(unit="ft/s^2")=32.2"Value of Acceleration due to Gravity in EE and BG units";
parameter Real c1(unit="N*s^2/(kg*m)")=1"Conversion factor";
//======================================================
// Variable Section
Real m2(unit="lbm")"Mass in English Engineering System";  
Real m3(unit="slug")"Mass in British Gravitational System";
Real w1(unit="N")"Weight in SI units";
Real w2(unit="slug*ft/s^2")"Weight in British Gravitational units";
Real w3(unit="lbm*ft/s^2")"Weight in English Engineering units";

//======================================================
// Equation Section
equation
m2=m1/k1"Mass in EE units";
m3=m2/k2"Mass in BG units";
w1=m1*g1*c1"Weight in SI units";
w2=m2*g2/g2"Weight in EE units";
w3=m3*g2"Weight in BG units";
end Ex1_4;
//=====================================================
