model Ex10_12
  //Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015
  //Chapter-10 : Fluid machinery
  //Example: 10.12   Page:552
  //Topic: Ideal analysis of a reaction turbine
  //===================================================================================
  //============================================================
  //Parameter Section
  parameter Real he(unit = "m") = 150 "Head at entrance";
  parameter Real dr(unit = "m") = 1.95 "Distance between the tailrace and header";
  parameter Real v1(unit = "m/s") = 34.5 "Runner tip speed";
  parameter Real v2(unit = "m/s") = 39 "Velocity at runner entrance";
  parameter Real v3(unit = "m/s") = 10.5 "Velocity at Runner exit";
  parameter Real v4(unit = "m/s") = 3.45 "Veloicity at draft tube exit";
  parameter Real lv(unit = "m") = 6 "Loss at volute";
  parameter Real ldt(unit = "m") = 1.05 "Loss at draft tube";
  parameter Real lr(unit = "m") = 9.9 "Loss at runner";
  parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";
  final constant Real pi = 2 * Modelica.Math.asin(1.0);
  //============================================================
  //Variable Section
  Real h3(unit = "m") "Head between runner exit and tailrace";
  Real h2(unit = "m") "Head between runner entrance and tailrace";
  Real ht(unit = "m") "Head extracted by turbine";
  Real vt2(unit = "m/s") "Tangential velocity at region-2";
  Real b2(unit = "") "Angle";
  Real a2(unit = "") "Angle";
  Real n(unit = "") "Efficiency";
  //============================================================
  //Equation Section
equation
  h3 = (v4 ^ 2 - v3 ^ 2) * 0.5 / g + ldt - dr "Expression for h3";
  h2 = he - lr - 0.5 * v2 ^ 2 / g "Expression for h2";
  ht = (-1*v4^2/(2*g)) + he + dr - (lv + ldt + lr) "Expression for ht";
  vt2 = g * ht / v1 "Expression for vt2";
  b2 = atan((vt2 - v1) / v3) * 180 / pi "Expression for b2";
  a2 = atan(vt2 / v3) * 180 / pi "Expression for a2";
  n = ht / he "Expression for n";
  annotation(experiment(StartTime = 0, StopTime = 6000, Tolerance = 1e-06, Interval = 12));
end Ex10_12;
