//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-10 : Fluid machinery
//Example: 10.19   Page:579
//Topic: Analysis of a giromill
//===================================================================================
model Ex10_19

//============================================================
//Parameter Section
parameter Real h(unit="m")=42"Height of giromill";
parameter Real d(unit="m")=33"Diameter of giromill";
parameter Real nm(unit="rev/min")=24"Minimum rotation speed";
parameter Real po(unit="kW")=120"Power of giromill";
parameter Real am(unit="")=12"Stall angle";
parameter Real ar(unit="")=50"Aspect ratio";
parameter Real cd(unit="")=0.006"Drag coefficient";
parameter Real p(unit="kg/m^3")=1.23"Density";
parameter Real c1(unit="rad* min/rev*s")=2*pi/60"Unit conversion factor";
parameter Real c2(unit="min/s")=1/60"Unit conversion constant";
parameter Real c3(unit="N*s^2/(kg*m)")=1"Unit conversion constant";
parameter Real c4(unit="W*s/(N*m)")=1"unit conversion constant";
parameter Real c5(unit="kW/W")=1e-3"unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//============================================================
//Variable Section
Real v(unit="m/s")"Velocity";
Real kef(unit="kW")"Kinetic energy flux";
Real n(unit="")"Efficiency";
Real x(unit="")"Tip speed ratio";
Real nl(unit="")"Lift efficiency";
Real no(unit="")"Overall efficiency";

//============================================================
//Equation Section
equation
v=0.5*d*nm*c1*tan(am*pi/180)"Expression for v";
kef=0.5*p*0.25*pi*d^2*v^3*c3*c4*c5"Expression for kef";
n=po/kef"Expression for n";
x=1/(tan(am*pi/180))"Expression for x";
nl=(1-(cd*((2/(cd*ar))+(4*x^3/(1+x^2)))))/(1+(cd*(1/(2*pi)+(3/(2*cd*ar*x^2)))))"Expresion for nl";
no=nl*n"Expression for no";
end Ex10_19;
//==============================================================
