//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-10 : Fluid machinery
//Example: 10.3   Page:513
//Topic: Idealized Axial-Flow Fan
//===================================================================================
model Ex10_3

//============================================================
//Parameter Section
parameter Real dt(unit="m")=1.1"Tip Diameter";
parameter Real dh(unit="m")=0.8"Hub Diameter";
parameter Real os(unit="rev/min")=1200"Operating Speed";
parameter Real a1(unit="")=30"Absolute inlet angle";
parameter Real b1(unit="")=30"Blade inlet angle";
parameter Real b2(unit="")=60"Blade outlet angle";
parameter Real p(unit="kg/m^3")=1.23"Density of air";
parameter Real c1(unit="rad*min/(rev*s)")=2/60"Unit conversion constant";
parameter Real c2(unit="N*s/(kg*m)")=1"Unit conversion constant";
parameter Real c3(unit="kW*s/(N*m)")=1E-3"Unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//============================================================
//Variable Section
Real rm(unit="m")"Mean radius";
Real u(unit="m/s")"Velocity";
Real vn1(unit="m/s")"Velocity";
Real v1(unit="m/s")"Velocity";
Real vt1(unit="m/s")"Velocity";
Real w1(unit="m/s")"Velocity";
Real q(unit="m^3/s")"Volumetric flowrate";
Real a2(unit="")"Angle";
Real v2(unit="m/s")"Velocity";
Real vt2(unit="m/s")"Velocity";
Real ts(unit="N*m")"Torque on shaft";
Real wm(unit="kW")"Power Required";

//============================================================
//Equation Section
equation
rm=(dt+dh)/4"Expresion for Mean radius";
u=rm*os*c1*pi"Expresion for u";
vn1=u/(tan(a1*pi/180)+ (1/tan(b1*pi/180)))"Expression for vn1";
v1=vn1/cos(a1*pi/180)"Expression for v1";
vt1=v1*sin(a1*pi/180)"Expression for vt1";
w1=vn1/sin(b1*pi/180)"Expression for w1";
q=vn1*pi*0.25*((dt)^2-(dh)^2)"Expression for q";
a2=180*atan((u-(vn1*(1/tan(b2*pi/180))))/vn1)/pi"Expression for a2";
v2=vn1/cos(a2*pi/180)"Expression for v2";
vt2=v2*sin(a2*pi/180)"Expression for vt2";
ts=p*q*rm*(vt2-vt1)*c2"Expression for ts";
wm=ts*os*c1*c3*pi"Expression for wm";
end Ex10_3;
//========================================================================
