//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  

//Chapter-3 : Pressure Variation in a Static Fluid
//Example: 3.7    Page:78
//Topic: Force component on a curved submerged surface
//==================================================================
model Ex3_7

//====================================================
//Parameter section
parameter Real p(unit="kg/m^3")=999"Density to water";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real w(unit="m")=5"Width of the surface";
parameter Real d(unit="m")=4"Depth of the curved surface";
parameter Real a(unit="m")=4"Constant in the equation of the curved surface";
parameter Real c(unit="kN*s^2/(kg*m)")=1E-3"unit conversion constant";

//====================================================
//Variable section
Real Fh(unit="kN")"Horizontal component of force";
Real Fv(unit="kN")"Vertical component of force";
Real F(unit="kN")"Force";
Real x(unit="m")"x co-ordinate of the centroid ";
Real y(unit="m")"y co-ordinate of the centroid ";
//=============================================
//Equation section
equation
Fh=p*d^2*g*c*w/2"Expression for evaluating horizontal component of force";
Fv=p*g*w*c*d^3/(3*a)"Expression for evaluating vertical component of force";
y=2*d/3"Expression for evaluating y co-ordinate of centroid";
x=3*d^2/(10*a)"Expression for evaluating x co-ordinate of centroid";
F=((x*Fv)+((d-y)*Fh))/w"Expression for evaluating the force";
end Ex3_7;
//============================================================================
