//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-4 : Basic equations in integral form for a control volume
//Example: 4.10   Page:126
//Topic: Vane moving with constant velocity 
//=======================================================================
model Ex4_10
//=======================================================
//Parameter Section
parameter Real theta(unit="")=60"Turning angle of the vane";
parameter Real a(unit="m^2")=0.003"Nozzle exit area";
parameter Real u(unit="m/s")=10"Velocity of Vane";
parameter Real v(unit="m/s")=30"Velocity of jet of water";
parameter Real d(unit="kg/m^3")=999"Density of water";
parameter Real c(unit="N*s/(m^2*kg)")=1"Unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);
final constant Real D2R=pi/180 "Degree to Radian";
//=======================================================
//Variable Section
Real rx(unit="N")"Horizontal component of force acting on vane";
Real ry(unit="N")"Vertical component of force acting on vane neglecting the weight of vane";

//=======================================================
//Equation Section
equation
rx=(v-u)*(cos(theta*D2R)-1)*(d*a*(v-u))*c"Horizontal component of force";
ry=(v-u)*sin(theta*D2R)*(d*(v-u)*a*c)"Vertical component of force";
end Ex4_10;
//========================================================================
