//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-4 : Basic equations in integral form for a control volume
//Example: 4.11   Page:131
//Topic: Vane moving with rectilinear acceleration 
//=======================================================================
model Ex4_11
//=======================================================
//Parameter Section
parameter Real theta(unit="")=60"turning angle of vane";
parameter Real m(unit="kg")=75"Mass of the cart and vane";
parameter Real v(unit="m/s")=35"Velocity of the cart";
parameter Real a(unit="m^2")=0.003"Nozzle exit area";
parameter Real d(unit="kg/m^3")=999"Density of water";
final constant Real pi=2*Modelica.Math.asin(1.0);
final constant Real D2R=pi/180 "Degree to Radian";
annotation(experiment(StartTime=0,StopTime=20,Tolerance=1e-6));
//=======================================================
//Variable Section
 
Real vb(unit="1/s");
Real uv(unit="");
//=======================================================
//Equation Section
equation
vb=v*(1-cos(theta*D2R))*d*a/m"Expression for vb ";
uv=vb*time/(1+(vb*time))"Expression for u/v";
end Ex4_11;
//================================================================
//Remark
//The start time = 0sec and Stop time =20sec for the given experiment, So by the changing the stop time in simulation setup, we can get the graph as shown in book.
