model Ex4_12
  //Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015
  //Chapter-4 : Basic equations in integral form for a control volume
  //Example: 4.12   Page:132
  //Topic: Rocket directed vertically
  //=======================================================================
  //=======================================================
  //Parameter Section
  parameter Real mo(unit = "kg") = 400 "Initial Mass";
  parameter Real me(unit = "kg/s") = 5 "Rate of fuel consumption";
  parameter Real ve(unit = "m/s") = 3500 "Exhuast Velocity";
  parameter Real g(unit = "m/s^2") = -9.81 "Acceleration due to gravity";
  //=======================================================
  //Variable Section
  Real ao(unit = "m/s^2") "Initial acceleration";
  Real v(unit = "m/s") "Velocity of the Rocket";
  //=======================================================
  //Equation Section
equation
  ao = ve * me / mo + g "Expression for initial acceleration";
  v = (-1 * ve * log((mo - me * time) / mo)) + g * time "Expression for velocity of the rocket";
  annotation(experiment(StartTime = 0, StopTime = 10, Tolerance = 1e-06, Interval = 0.02));
end Ex4_12;
