//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  

//Chapter-4 : Basic equations in integral form for a control volume
//Example: 4.7   Page:119
//Topic: Flow under a sluice gate: hydrostatic pressure force
//=======================================================================
model Ex4_7
//=======================================================
//Parameter Section
parameter Real p(unit="kg/m^3")=999"Density of water";
parameter Real d1(unit="m")=3"Diameter of section 1";
parameter Real d2(unit="m")=0.429"Diameter of section 2";
parameter Real v1(unit="m/s")=1"Velocity in section 1";
parameter Real v2(unit="m/s")=7"Velocity in section 2";
parameter Real g(unit="m^2/s")=9.81"Accelerattion due to gravity";
parameter Real c(unit="kN*s/(kg*m^2)")=1E-3"Unit conversion constant";
//=======================================================
//Variable Section
Real rxw(unit="kN/m")"Horizontal force per unit width";
Real kx(unit="kN/m")"Force of the water on the gate";

//=======================================================
//Equation Section
equation 
rxw=(p*c*(v2^2*d2-v1^2*d1))-(p*0.5*g*c*(d1^2-d2^2))"Expression for Horizontal force ";
kx=-1*rxw"Expression for force of the water on the gate";
end Ex4_7;
//================================================================
